<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$current_user = wp_get_current_user();
do_action( 'woocommerce_before_account_navigation' );
?>
<nav class="woocommerce-MyAccount-navigation" aria-label="<?php esc_html_e( 'Account pages', 'woocommerce' ); ?>">
	<ul>
		<div class="woocommerce-top-navigation">
			<?php echo get_avatar( $current_user->user_email, 96 ); // Display user profile image ?>
			<div class="ms-myaccount-avatar-name-code">
				<p class="name"><?php echo esc_html( $current_user->display_name ); ?></p>
				<div>
					<span class="user_code">کد کاربر:</span>
					<span class="user_code_value"><?php echo esc_html( $current_user->id ); ?> #</span>
				</div>
			</div>
			<a href="/my-account/edit-account/">
				<i class="isax isax-edit"></i>
			</a>
		</div>
		<?php
		$endpoints = array(
			'downloads' => get_option( 'woocommerce_myaccount_downloads_endpoint', 'downloads' ),
			'orders' => get_option( 'woocommerce_myaccount_orders_endpoint', 'orders' ),
			'edit-address' => get_option( 'woocommerce_myaccount_edit_address_endpoint', 'edit-address' ),
			'payment-methods' => get_option( 'woocommerce_myaccount_payment_methods_endpoint', 'payment-methods' ),
			'edit-account' => get_option( 'woocommerce_myaccount_edit_account_endpoint', 'edit-account' ),
			'customer-logout' => get_option( 'woocommerce_logout_endpoint', 'customer-logout' ),
		);

		$setup_theme_instance = new Setup_Theme();

		$items = $setup_theme_instance->customize_woocommerce_profile();

		// Remove missing endpoints.
		foreach ( $endpoints as $endpoint_id => $endpoint ) {
			if ( empty( $endpoint ) ) {
				unset( $items[ $endpoint_id ] );
			}
		}

		// Check if payment gateways support add new payment methods.
		if ( isset( $items['payment-methods'] ) ) {
			$support_payment_methods = false;
			foreach ( WC()->payment_gateways->get_available_payment_gateways() as $gateway ) {
				if ( $gateway->supports( 'add_payment_method' ) || $gateway->supports( 'tokenization' ) ) {
					$support_payment_methods = true;
					break;
				}
			}

			if ( ! $support_payment_methods ) {
				unset( $items['payment-methods'] );
			}
		}
		foreach ( $items as $endpoint => $label ) : ?>
			<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
				<a
					href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
				<i class="isax isax-arrow-left-2"></i>
			</li>
		<?php endforeach; ?>
	</ul>
</nav>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
