<?php
/**
 * Template part for displaying single post author box
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if( option_value('single-post-author-box') ) {
    ?>
    <div class="single-author-box-container">
        <div class="single-author-box">
            <div class="single-author-box-avatar">
                <?php echo get_avatar( get_the_author_meta( 'user_email' ), 120 ); ?>
            </div>
            <div class="single-author-box-desc">
                <a class="button more-articles" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>"><?php esc_html_e('Follow Me', THEME_NAME); ?></a>
                <span class="written-by"><?php esc_html_e('Written By', THEME_NAME); ?></span>
                <h4 class="author-name"><?php echo esc_html(get_the_author()); ?></h4>
                <p class="author-bio"><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
    <?php
}