<?php
/**
 * Template part for displaying default header
 */
?>
<?php

?>
<div class="header-default">
    <div class="header-default-top">
        <div class="container">
            <div class="row align-items-center">
                <?php
                $has_menu = has_nav_menu( 'primary_menu' );
                ?>
                <div class="d-flex <?php $cls = $has_menu? 'col-6 justify-content-center' : 'col-9';  echo esc_html($cls); ?>">
                    <a href="<?php echo home_url('/'); ?>"><?php bloginfo('name'); ?></a>
                </div>
                <div class="col-3 d-flex justify-content-end">
                    <?php if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly
                    $search_type = ( isset($settings['search_type']) && $settings['search_type'] == 'inline' )? 'inline' : 'popup';
                    ?>
                    <div class="popup-search-wrapper <?php echo esc_html($style); ?>">
                        <div class="popup-search-opener-wrapper">
                            <span class="popup-search-opener"><i class="isax isax-search-normal-1"></i></span>
                        </div>
                        <div class="popup-search">
                            <div class="popup-search-container">
                                <span class="popup-search-closer"></span>
                                <div class="popup-search-content">
                                    <div class="popup-search-title-wrapper">
                                        <h3><?php esc_html_e('Type and hit Enter to search', THEME_NAME); ?></h3>
                                    </div>
                                    <div class="popup-search-form-wrapper">
                                        <form action="<?php echo home_url('/'); ?>" method="get" class="popup-search-form">
                                            <input type="text" name="s" value="" class="search-field" placeholder="<?php esc_html_e('Search ...', THEME_NAME); ?>" aria-label="Search" required>
                                            <button type="submit" class="submit" aria-label="Submit">
                                                search
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    if ( $has_menu ) {
        ?>
        <div class="header-default-bottom">
            <div class="container">
                <nav class="theme-header-nav-wrapper">
                <?php    // Menu
                wp_nav_menu( array(
                    'theme_location' => 'primary_menu',
                    'link_before' => '<span>',
                    'link_after'=>'</span>',
                    'fallback_cb' => false,
                    'container' => false,
                    'menu_class' => 'theme-header-nav',
                ) );
                ?>
                </nav>
            </div>
        </div>
        <?php
    }
    ?>
</div>

