<div class="default-archive-container">
    <div class="row">
    <?php
    
    if( have_posts() ) {
        while(have_posts()) {
            the_post();
            ?>
            <div class="col-3">
                <article <?php post_class( 'default-post-list-item' ); ?>>
                    <div class="image-container">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('theme-large', array( 'title' => get_the_title() )); ?>
                            </a>
                            <?php 
                            $post_format = get_post_format() ? : 'standard';

                            switch ($post_format) {
                                case 'gallery':
                                    $post_format_icon = 'isax isax-image';
                                    break;
                                case 'video':
                                    $post_format_icon = 'isax isax-video';
                                    break;
                                case 'audio':
                                    $post_format_icon = 'isax isax-audio-square';
                                    break;
                                case 'link':
                                    $post_format_icon = 'isax isax-link';
                                    break;
                                case 'quote':
                                    $post_format_icon = 'isax isax-quote-down';
                                    break;
                                default:
                                    $post_format_icon = 'isax isax-note';
                            }

                            ?>
                            <div class="post-format-icon theme-position-top-left">
                                <i class="<?php echo esc_html($post_format_icon) ?>"></i>
                            </div>

                        <?php endif; ?>
                    </div>
                    <div class="content-container">
                        <div class="category">
                            <?php
                            $categories = get_the_category();
                            foreach ($categories as $category) {
                                echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( $category->name ) . '">' . esc_html( $category->name ) . '</a>';
                            }
                            ?>
                        </div>
                        <h2 class="title"><span class="title-span"><a class="title-animation-underline" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span></h2>
                        <div class="meta">
                            <div class="author">
                                <a class="author-avatar" target="_blank" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>">
                                    <?php echo get_avatar( get_the_author_meta( 'user_email' ), 45 ); ?>
                                </a>
                                <a class="author-name" target="_blank" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>">
                                    <?php echo esc_attr(get_the_author()); ?>
                                </a>
                            </div>
                            <div class="meta-item date">
                                <span><?php echo get_the_date(); ?></span>
                            </div>
                        </div>
                        <div class="excerpt">
                            <?php the_excerpt(); ?>
                        </div>
                        <a class="button" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', THEME_NAME); ?></a>
                    </div>
                </article>
            </div>
            <?php
        }
        ?>
        </div>

        <?php
        global $wp_query;
        if ( $wp_query->max_num_pages > 1 ) :
            ?>
            <nav class="default-post-list-pagination">
                <?php
                $paginate_args = array(
                    'current'   => max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) ),
                    'total'     => $wp_query->max_num_pages,
                    'prev_next' => true,
                );
                echo paginate_links( $paginate_args );
                ?>
            </nav>
        <?php endif;
        
    }
    else {
        ?>
        <div class="nothing-show">
            <h2><?php esc_html_e('Nothing found!', THEME_NAME); ?></h2>
            <p><?php esc_html_e('It looks like nothing was found here!', THEME_NAME); ?></p>
        </div>
        <?php
    }
    ?>

</div>
