<?php


use handler\product_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_tab extends \Elementor\Widget_Base {

	use product_Query;
	use Post_skin_base;
	use swiper;
	use basic_element;

	public function get_name() {
        return 'ar_woo_product_tab';
    }

    public function get_title() {
        return esc_html__('product tab', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_tab';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'tab_section',
            [
                'label' => __( 'tabs', THEME_NAME ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_name',
            [
                'label' => __( 'title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'title', THEME_NAME ),
            ]
        );

        $repeater->add_control(
            'body_centent',
            [
                'label'     => esc_html__( 'content', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'product_desc'              => esc_html__( 'product description', THEME_NAME ),
                    'product_attr'       => esc_html__( 'product attribute', THEME_NAME ),
                ],
            ]
        );

        $repeater->add_control(
            'show_category',
            [
                'label'       => esc_html__( 'show category', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'show_tags',
            [
                'label'       => esc_html__( 'show tags', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::SWITCHER,
            ]
        );
        
        $this->add_control(
            'tabs',
            [
                'label' => __( 'categories', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '{{{ tab_name }}}',
            ]
        );

        $this->end_controls_section();
    }

	protected function register_content_section_2() {

		$this->start_controls_section(
			'section_layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ 
					'grid' => esc_html__( 'Grid', THEME_NAME ),
					'carousel' => esc_html__( 'Carousel', THEME_NAME ),
				],
				'default' => 'grid',
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_control(
			'hover',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
			]
		);

		$this->add_control(
			'icon',
			[ 
				'label' => __( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);


		$this->end_controls_section();

	}

    protected function register_style_section_1() {
        
        $this->start_controls_section(
            'container_section',
            [
                'label' => esc_html__( 'container', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('gallery',  '.gallery');
		$this->register_container_style( 'gallery-cart', '.gallery-cart' );



        $this->add_control(
		    'top_bar_section',
		    [
			    'label'     => esc_html__( 'top bar', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_container_style('tabs',  '.tabs');

        $this->add_control(
		    'noraml_btn_section',
		    [
			    'label'     => esc_html__( 'normal button', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('normal_tab',  '.tab-btn');

        $this->add_control(
		    'active_btn_section',
		    [
			    'label'     => esc_html__( 'active button', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('active_btn',  '.tab-btn.active');


        $this->end_controls_section();
    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'product_description_section',
            [
                'label' => esc_html__( 'product description', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_text',  '.product-description');

        $this->end_controls_section();
    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'product_attributes_section',
            [
                'label' => esc_html__( 'product attributes', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'container_section',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'theme-posts-wrapper', '.theme-posts-wrapper' );

		$this->add_control(
			'items_section',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'article', 'article' );

		$this->add_control(
			'items_name_section',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'article-name', 'article p.name', $align = false );

		$this->add_control(
			'items_value_section',
			[ 
				'label' => esc_html__( 'value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'article-value', 'article p.value', $align = false );

		$this->add_control(
			'icon-sep',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon', '.icon', $align = false );

        $this->end_controls_section();
    } 

    protected function register_style_section_4() {
        $this->start_controls_section(
            'product_category_section',
            [
                'label' => esc_html__( 'product category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'category_title',
			[
				'label' => esc_html__( 'category title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category_title',  '.product-category-title', $align=false);

        $this->add_control(
			'category',
			[
				'label' => esc_html__( 'category', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category',  '.product-category', $align=false);


        $this->add_control(
			'category-box',
			[
				'label' => esc_html__( 'category box', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_category_box',  '.product-category-box');

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'product_tag_section',
            [
                'label' => esc_html__( 'product tag', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'tag_title',
			[
				'label' => esc_html__( 'tag title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag_title',  '.product-tag-title', $align=false);

        $this->add_control(
			'tag',
			[
				'label' => esc_html__( 'tag', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag',  '.product-tag', $align=false);


        $this->add_control(
			'category-box',
			[
				'label' => esc_html__( 'tag box', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('product_tag_box',  '.product-tag-box');

        $this->end_controls_section();
    }

    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_content_section_2();
        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_carousel_controls();
		$this->register_style_carousel_controls();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
		$widget_id = $this->get_id();

		if ( empty( $settings['tabs'] ) ) {
			echo 'ابتدا دسته بندی ها را اضافه کنید';
			return;
		}
        echo '<div class="gallery">';
            echo '<div class="tabs">';
            foreach ($settings['tabs'] as $index => $tab) {
                $tab_id = 'tab' . ($index + 1);
                $tab_name = esc_html($tab['tab_name']);
                echo '<button class="tab-btn';
                echo ($index === 0) ? ' active' : '';
                echo '" data-category="' . $tab_id . '" onclick="show_widgets.call(this, \'' . $tab_id . '\')">' . $tab_name . '</button>';
            }
            echo '</div>';
            if ($this->theme_is_edit_mode()) {
                $first_product_id = get_posts(array(
                    'post_type'      => 'product',
                    'posts_per_page' => 1,
                    'orderby'        => 'ID',
                    'order'          => 'ASC',
                    'fields'         => 'ids',
                ));
                $first_product = wc_get_product($first_product_id[0]);
                
                if ($first_product) {
                    foreach ($settings['tabs'] as $index => $tab) {
                        $tab_id = 'tab' . ($index + 1);
                        echo '<div class="content"';
                        echo ($index === 0) ? ' style="display: flex;"' : 'style="display: none;"';
                        echo 'id="' . $tab_id . '">';
                        echo '<div class="gallery-cart">';
                        
                        if ($tab['body_centent'] == 'product_desc'){
                            echo '<div class="product-description">' .  wp_kses_post($first_product->get_description()) . '</div>';
                            
                            if ($tab['show_category']) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i     = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-category" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ($tab['show_tags']) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }

                            
                        }
                        if ($tab['body_centent'] == 'product_attr') {
						    ?>
                            <div class="theme-posts-container theme-post-widget">
                            <?php
                            $post_wrapper_cls = '';
                            if ( $settings['layout'] == 'grid' ) {
                                $post_wrapper_cls = 'theme-posts-wrapper';
                            }
                            ?>
                            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                            <?php $this->render_carousel_header(); ?>
                            <?php
                            $product_attributes = $first_product->get_attributes();
                            $post_item_cls = 'post-item';
                            if ( $settings['layout'] == 'carousel' ) {
                                $post_item_cls = ' swiper-slide';
                            }
                            foreach ($product_attributes as $attribute) {         
                                $options = $attribute->get_options();
							    $attribute_label = wc_attribute_label( $attribute->get_name() );
                                $attribute_values = [];

                                if ( $attribute->is_taxonomy() ) {
                                    $terms = wc_get_product_terms( $first_product_id[0], $attribute->get_name(), array( 'fields' => 'names' ) );
                                    $attribute_values = array_map( 'wp_kses_post', $terms );
                                } else {
                                    // If it's not taxonomy-based, just output the options as they are
                                    $attribute_values = array_map( 'wp_kses_post', $options );
                                }
								?>
                                <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                    <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $settings['hover'], 'd-flex flex-row' ) ); ?>>
                                        <div class="icon d-flex align-items-center justify-content-center">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                        <?php
                                        echo '<p class=name>' . wp_kses_post($attribute_label) . ':</p>';
                                        echo '<p class=value>' . implode(', ', $attribute_values) . '</p>';
										?>
                                    </article>
                                </div>
                            <?php
                            }
                            foreach (option_value('page-single-product-attribute') as $index => $item) {
								$attr_id =get_post_meta( $first_product->get_id(), 'product_' . $index, true );
                                if ($attr_id):
                                ?>
                                <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                    <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $settings['hover'], 'd-flex flex-row' ) ); ?>>
                                        <div class="icon d-flex align-items-center justify-content-center">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                        <?php
                                        echo '<p class=name>' . $item . ':</p>';
                                        $attr_id =get_post_meta( $first_product->get_id(), 'product_' . $index, true );
                                        echo '<p class=value>' . $attr_id . '</p>';
										?>
                                    </article>
                                </div>
                                <?php
								endif;
                            }
							$this->render_carousel_footer();
							?>
                            </div>
                            <?php
                            if ( $tab['show_category'] ) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-category" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ( $tab['show_tags'] ) {
                                $product_categories = wp_get_post_terms( $first_product_id[0], 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }
                        }

                        echo '</div>';
                        echo '</div>'; 
                    }
                }
            }

            else {
                global $post;
                $product_slug = $post->post_name;
                $product = get_page_by_path($product_slug, OBJECT, 'product');
                
                if ($product) {
                    foreach ($settings['tabs'] as $index => $tab) {
                        $tab_id = 'tab' . ($index + 1);
                        echo '<div class="content"';
                        echo ($index === 0) ? ' style="display: flex;"' : 'style="display: none;"';
                        echo 'id="' . $tab_id . '">';
                        echo '<div class="gallery-cart">';
                        $product_attributes = $product ? wc_get_product($product->ID)->get_attributes() : [];
                        if ($tab['body_centent'] == 'product_desc'){
                            echo '<div class="product-description">' .  wp_kses_post($product->post_content) . '</div>';
                            
                            if ($tab['show_category']) {
                                $product_categories = wp_get_post_terms( $product->ID, 'product_cat', array( 'fields' => 'all' ) );
                                echo '<div class="product-category-box">';
                                echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    $count = count( $product_categories );
                                    $i     = 0;
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                        if ( ++$i !== $count ) {
                                            echo ', ';
                                        }
                                    }
                                }
                                echo '</div>';
                            }

                            if ($tab['show_tags']) {
                                $product_categories = wp_get_post_terms( $product->ID, 'product_tag', array( 'fields' => 'all' ) );
                                echo '<div class="product-tag-box">';
                                echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
                                if ( ! empty( $product_categories ) ) {
                                    foreach ( $product_categories as $category ) {
                                        $category_url = get_term_link( $category );
                                        echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
                                    }
                                }
                                echo '</div>';
                            }
                        }
                        if ($tab['body_centent'] == 'product_attr') {
						    ?>
							<div class="theme-posts-container theme-post-widget">
							<?php
                            $post_wrapper_cls = '';
                            if ( $settings['layout'] == 'grid' ) {
                                $post_wrapper_cls = 'theme-posts-wrapper';
                            }
                            ?>
                            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                            <?php $this->render_carousel_header(); ?>
                            <?php
                            $post_item_cls = 'post-item';
                            if ( $settings['layout'] == 'carousel' ) {
                                $post_item_cls = ' swiper-slide';
                            }
                            foreach ($product_attributes as $attribute) {         
                                $options = $attribute->get_options();
							    $attribute_label = wc_attribute_label( $attribute->get_name() );
                                $attribute_values = [];

                                if ( $attribute->is_taxonomy() ) {
                                    $terms = wc_get_product_terms( $product->ID, $attribute->get_name(), array( 'fields' => 'names' ) );
                                    $attribute_values = array_map( 'wp_kses_post', $terms );
                                } else {
                                    // If it's not taxonomy-based, just output the options as they are
                                    $attribute_values = array_map( 'wp_kses_post', $options );
                                }
								?>
								<div class="<?php echo esc_html( $post_item_cls ); ?>">
									<article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $settings['hover'], 'd-flex flex-row' ) ); ?>>
										<div class="icon d-flex align-items-center justify-content-center">
										<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
										</div>
										<?php
										echo '<p class=name>' . wp_kses_post( $attribute_label ) . ':</p>';
										echo '<p class=value>' . implode( ', ', $attribute_values ) . '</p>';
										?>
									</article>
								</div>
							<?php
                            }
							foreach ( option_value( 'page-single-product-attribute' ) as $index => $item ) {
                                $attr_id = get_post_meta( get_the_ID(), 'product_' . $index, true );
                                if ($attr_id):
                                ?>
                                <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                    <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $settings['hover'], 'd-flex flex-row' ) ); ?>>
                                        <div class="icon d-flex align-items-center justify-content-center">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                        <?php
										echo '<p class=name>' . $item . ':</p>';
										$attr_id = get_post_meta( get_the_ID(), 'product_' . $index, true );
										echo '<p class=value>' . $attr_id . '</p>';
										?>
                                    </article>
                                </div>
                                <?php
								endif;
							}
							$this->render_carousel_footer();
							?>
                            </div>
                            </div>
                            <?php
							if ( $tab['show_category'] ) {
								$product_categories = wp_get_post_terms( $product->ID, 'product_cat', array( 'fields' => 'all' ) );
								echo '<div class="product-category-box">';
								echo '<span class="product-category-title">' . esc_html__( 'category', THEME_NAME ) . ': </span>';
								if ( ! empty( $product_categories ) ) {
									$count = count( $product_categories );
									$i = 0;
									foreach ( $product_categories as $category ) {
										$category_url = get_term_link( $category );
										echo '<span><a href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
										if ( ++$i !== $count ) {
											echo ', ';
										}
									}
								}
								echo '</div>';
							}

							if ( $tab['show_tags'] ) {
								$product_categories = wp_get_post_terms( $product->ID, 'product_tag', array( 'fields' => 'all' ) );
								echo '<div class="product-tag-box">';
								echo '<span class="product-tag-title">' . esc_html__( 'tag', THEME_NAME ) . ': </span>';
								if ( ! empty( $product_categories ) ) {
									foreach ( $product_categories as $category ) {
										$category_url = get_term_link( $category );
										echo '<span><a class="product-tag" href="' . esc_url( $category_url ) . '">' . esc_html( $category->name ) . '</a></span>';
									}
								}
								echo '</div>';
							}
                            
                        }

                        echo '</div>';
                        echo '</div>';
                        do_action( 'woocommerce_after_single_product' );

                    }
                }
            }
            ?>
		    <script>
			jQuery( document ).ready( function ( $ )
			{
				var carouselPosts = $( '#theme-carousel-<?php echo $this->get_id() ?>' );

					// Get all elements with the class '.theme-posts-carousel-wrapper'
					var carouselSettings = $( carouselPosts ).data( 'settings' );

					// Find the swiper container within the current carousel
					var carouselContainer = $( carouselPosts ).find( '.swiper-container' )[ 0 ];

					// Initialize Swiper for the current carousel
					var swiper<?php echo $element_id;
					echo $widget_id; ?> = new Swiper( carouselContainer, carouselSettings );
					$( '.swiper-prev-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex > 0 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slidePrev();
						}
					} );

					$( '.swiper-next-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex < swiper<?php echo $element_id;
						  echo $widget_id; ?>.slides.length - 1 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slideNext();
                        }
                    } );

                } );
            </script>
		    <?php
        echo '</div>';
    }

}