<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_status extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_status';
    }

    public function get_title() {
        return esc_html__('product status', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_status';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => esc_html__( 'product status', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('theme_product_status',  '.theme-product-status');

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if ( $this->theme_is_edit_mode() ) {
			$first_product_id = get_posts( array(
				'post_type' => 'product',
				'posts_per_page' => 1,
				'orderby' => 'ID',
				'order' => 'ASC',
				'fields' => 'ids',
			) );
			$stock_status = get_post_meta( $first_product_id[0], '_stock_status', true );

			if ( $stock_status === 'instock' ) {
				$stock_status = __( 'instock', THEME_NAME );

			} elseif ( $stock_status === 'outofstock' ) {
				$stock_status = __( 'outofstock', THEME_NAME );

			} elseif ( $stock_status === 'onbackorder' ) {
				$stock_status = __( 'onbackorder', THEME_NAME );

			}
			echo '<p class="theme-product-status">' . esc_html( $stock_status ) . '</p>';
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );

			$stock_status = get_post_meta( $product_id, '_stock_status', true );

			if ( $stock_status === 'instock' ) {
				$stock_status = __( 'instock', THEME_NAME );

			} elseif ( $stock_status === 'outofstock' ) {
				$stock_status = __( 'outofstock', THEME_NAME );

			} elseif ( $stock_status === 'onbackorder' ) {
				$stock_status = __( 'onbackorder', THEME_NAME );

			}
			echo '<p class="theme-product-status">' . esc_html( $stock_status ) . '</p>';
		}
	}

}