<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_off_percentage extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_off_percentage';
    }

    public function get_title() {
        return esc_html__('product off percentage', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_off_percentage';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'discount percentage', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('discount-percentage',  '.discount-percentage');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            echo '<p class="discount-percentage">23</p>';

            
        } else {
            global $post;
            $product_slug = $post->post_name;
            $product = get_page_by_path($product_slug, OBJECT, 'product');
            if ($product) {
                $regular_price = wc_get_product($product)->get_regular_price();
                $sale_price = wc_get_product($product)->get_sale_price();
                $discount_percentage = 0;
				if( $sale_price) {
					$discount_percentage = ceil( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
                    echo '<p class="discount-percentage">' . $discount_percentage . ' %</p>';
				}
                
            }
        }
    }


}