<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_author extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_author';
    }

    public function get_title() {
        return esc_html__('product author', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_author';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_style_section',
            [
                'label' => esc_html__( 'category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-author');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_product = wc_get_product($first_product_id[0]);
            
            $author_id = $first_product->post_author;
            $author_name = get_the_author_meta('display_name', $author_id);

            echo '<div class="product-author">';
            echo '<a href="' . esc_url(get_author_posts_url($author_id)) . '">' . esc_html($author_name) . '</a>';
            echo '</div>';
        } else {
            global $post;
            $author_id = $post->post_author;
            $author_name = get_the_author_meta('display_name', $author_id);

            echo '<div class="product-author">';
            echo '<a href="' . esc_url(get_author_posts_url($author_id)) . '">' . esc_html($author_name) . '</a>';
            echo '</div>';
        }
    }



}