<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class ar_woo_product_add_to_cart extends \Elementor\Widget_Base {

	use basic_element;


	public function get_name() {
		return 'ar_woo_product_add_to_cart';
	}

	public function get_title() {
		return esc_html__( 'product add to cart', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_woo_product_add_to_cart';
	}

	public function get_categories() {
		return [ 'core-elementor-elements' ];
	}


	protected function register_content_section_1() {
		$this->start_controls_section(
			'section_general',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
			]
		);

		$this->add_control(
			'text',
			[ 
				'label' => esc_html__( 'Text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'dynamic' => [ 
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_1() {
		$this->start_controls_section(
			'product_price_style_section',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'product_categories', '.single_add_to_cart_button', $align = false );


		$this->end_controls_section();

	}

	protected function register_style_section_2() {
		$this->start_controls_section(
			'product_amount_style_section',
			[ 
				'label' => esc_html__( 'quantity', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'quantity', '.qty', $align = false );

		$this->add_control(
			'plus-button',
			[ 
				'label' => esc_html__( 'plus button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'plus-button', '.plus', $align = false );

		$this->add_control(
			'minus-button',
			[ 
				'label' => esc_html__( 'minus button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'minus-button', '.minus', $align = false );

		$this->end_controls_section();

	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'product_option_style_section',
			[ 
				'label' => esc_html__( 'options', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'label-options',
			[ 
				'label' => esc_html__( 'label', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'label-options', 'label', $align = false );

		$this->add_control(
			'select-options',
			[ 
				'label' => esc_html__( 'select', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'select-options', 'select', $align = false );

		$this->add_control(
			'option-options',
			[ 
				'label' => esc_html__( 'option', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'option-options', 'option', $align = false );

		$this->add_control(
			'reset-options',
			[ 
				'label' => esc_html__( 'reset', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'reset-options', '.reset_variations', $align = false );

		$this->end_controls_section();

	}

	protected function register_controls() {

		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
	}


	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		$settings = $this->get_settings_for_display();

		if ( $this->theme_is_edit_mode() ) {
			?>
				<form
					class="variations_form cart"
					enctype="multipart/form-data"
				>
					<table class="variations" cellspacing="0" role="presentation">
						<tbody>
							<tr>
								<th class="label"><label for="pa_%d8%b1%d9%86%da%af">رنگ</label></th>
								<td class="value">
									<select id="pa_%d8%b1%d9%86%da%af" class="" name="attribute_pa_%d8%b1%d9%86%da%af" data-attribute_name="attribute_pa_%d8%b1%d9%86%da%af" data-show_option_none="yes">
										<option value="">یک گزینه را انتخاب کنید</option>
										<option value="%d8%b3%d8%a8%d8%b2" class="attached enabled">سبز</option>
										<option value="%d9%82%d8%b1%d9%85%d8%b2" class="attached enabled">قرمز</option>
									</select>
									<a class="reset_variations" href="#" style="visibility: visible;">پاک کردن</a>
								</td>
							</tr>
						</tbody>
					</table>

					<div class="single_variation_wrap">
						<div class="woocommerce-variation single_variation" style="display: block;">
							<div class="woocommerce-variation-description"></div>
							<div class="woocommerce-variation-price">
								<span class="price">
									<span class="woocommerce-Price-amount amount">
										<bdi>100،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
									</span>
								</span>
							</div>
							<div class="woocommerce-variation-availability"></div>
						</div>
						<div class="woocommerce-variation-add-to-cart variations_button woocommerce-variation-add-to-cart-enabled">
							<div class="quantity">
								<label class="screen-reader-text" for="quantity_66bcf66e39c59">پادکست اموزش زمان بندی عدد</label>
								<button type="button" class="plus">+</button>
								<input type="number" id="quantity_66bcf66e39c59" class="input-text qty text" name="quantity" value="1" aria-label="تعداد محصول" size="4" min="1" max="" step="1" placeholder="" inputmode="numeric" autocomplete="off" />
								<button type="button" class="minus">-</button>
							</div>

							<button type="submit" class="single_add_to_cart_button button alt">افزودن به سبد خرید</button>

							<input type="hidden" name="add-to-cart" value="3774" />
							<input type="hidden" name="product_id" value="3774" />
							<input type="hidden" name="variation_id" class="variation_id" value="7011" />
						</div>
					</div>
				</form>
			<?php
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
			if ( $product ) {
				the_post();
				global $product;
				do_action( 'woocommerce_before_add_to_cart_form' );
				do_action( 'woocommerce_' . $product->get_type() . '_add_to_cart' );
				do_action( 'woocommerce_after_add_to_cart_form' );
			}
		}
	}

}