<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_order_track extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_order_track';
    }

    public function get_title() {
        return esc_html__('order track', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_order_track';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section('section_style_text',
		    [
			    'label' => esc_html__('texts', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_text_style('texts', 'p');
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section( 'section_style_label',
			[ 
				'label' => esc_html__( 'label', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'label', 'label' );
		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section( 'section_style_input',
			[ 
				'label' => esc_html__( 'input', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'input', 'input' );
		$this->end_controls_section();
	}

	protected function register_style_section_4() {
		$this->start_controls_section( 'section_style_button',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'button', 'button', $align=false );
		$this->end_controls_section();
	}


	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
		$this->register_style_section_4();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		echo \WC_Shortcodes::order_tracking([]);
    }
}