<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_mini_cart extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_mini_cart';
    }

    public function get_title() {
        return esc_html__('mini cart', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_mini_cart';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__( 'Button Title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Button Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);
            $this->end_controls_section();
    }   

    protected function register_style_section_1() {
        $this->start_controls_section(
            'cart_image',
		    [
			    'label' => esc_html__('image', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('product_name_back',  '.product-name img');

        $this->add_control(
		    'image',
		    [
			    'label' => esc_html__( 'image', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_image_style('product_img', '.product-name img');
        $this->end_controls_section();
    }
    
    protected function register_style_section_2() {
        $this->start_controls_section(
            'cart_name',
		    [
			    'label' => esc_html__('product name', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_text_style('theme_product_title',  '.product-name a', $align=false);
        $this->end_controls_section();
    }

    protected function register_style_section_3() {
        $this->start_controls_section(
            'discount_percentage',
            [
                'label' => esc_html__( 'discount percentage', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_text_style('sale_aomunt_discount_percentage',  '.discount-percentage', $align=false);

        $this->end_controls_section();

    } 

    protected function register_style_section_4() {
        $this->start_controls_section(
            'cart_quantity',
            [
                'label' => esc_html__( 'quantity', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('product_quantity_back',  '.qty');
        $this->register_text_style('theme_product_quantity',  '.qty');

        $this->end_controls_section();

    } 

    protected function register_style_section_5() {
        $this->start_controls_section(
            'cart_sub_price',
            [
                'label' => esc_html__( 'sub price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('product_subtotal_back',  '.product-subtotal');

        $this->add_control(
		    'amount_price',
		    [
			    'label' => esc_html__( 'amount', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('theme_product_sub_price',  '.product-subtotal .woocommerce-Price-amount', $align=false);

        $this->add_control(
		    'total_label_price',
		    [
			    'label' => esc_html__( 'real price', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('theme_product_sub_real_price',  '.real-price');

        $this->add_control(
		    'currencySymbol_total',
		    [
			    'label' => esc_html__( 'currency Symbol', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price_currencySymbol_total',  '.product-subtotal .woocommerce-Price-currencySymbol', $align=false);
        $this->end_controls_section();

    }
    
    protected function register_style_section_6() {
        $this->start_controls_section(
            'cart_button',
            [
                'label' => esc_html__( 'total price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->register_container_style( 'button', '.price-containers');

		$this->add_control(
			'price-tag_style',
			[ 
				'label' => esc_html__( 'price label', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'price-tag', '.price-tag' );

		$this->add_control(
			'price-value_style',
			[ 
				'label' => esc_html__( 'price value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'price-value', '.price-value', $align = false );

		$this->add_control(
			'price-unit_style',
			[ 
				'label' => esc_html__( 'price unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'price-unit', '.price-unit', $align = false );

		$this->add_control(
			'button_style',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('button',  '.cart-btn' , $align=false);
        $this->end_controls_section();

    }

    protected function register_style_section_7() {
        $this->start_controls_section(
            'remove_icon',
            [
                'label' => esc_html__( 'remove icon', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->register_container_style('product_remove_back',  '.product-remove');

		$this->start_controls_tabs( 'tabs_remove_icon_style' );

		$this->start_controls_tab(
			'tabs_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

        $this->register_text_style('remove_icon_text',  '.remove i' , $align=false);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_hover',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'remove_icon_text_hover', '.remove:hover i', $align = false );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

    }

    
    protected function register_style_section_8() {
        $this->start_controls_section(
            'cart_empty',
            [
                'label' => esc_html__( 'cart empty', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_text_style('empty',  '.empty');
        $this->end_controls_section();

    }

	protected function register_style_section_9() {
		$this->start_controls_section(
			'btn-text',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'single-share-box-container', '.single-share-box-container' );

	}
    protected function register_controls() {
        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
        $this->register_style_section_7();
        $this->register_style_section_8();
		$this->register_style_section_9();

    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
        ?>
        <div class="box-share-btn">
                <p class="share-text"><?php echo esc_html($settings['btn_title']);?></p>
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            <div class="single-share-box-container mt-4">
                <?php
                if ( $this->theme_is_edit_mode()) {
                    ?>
                    <div class="elementor-element elementor-element-24318d9 elementor-widget elementor-widget-ar_woo_mini_cart" data-id="24318d9" data-element_type="widget" data-widget_type="ar_woo_mini_cart.default">
                        <div class="elementor-widget-container">
                            
                            <form class="woocommerce-cart-form" action="http://shopex.test/cart/" method="post">
                                <div class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
                                    <div class="p-2 woocommerce-cart-form__cart-item cart_item">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center product-name" data-title="محصول">
                                                <a href="http://shopex.test/product/%d8%af%d9%88%d8%b1%d9%87-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">
                                                    <?php echo sprintf( '<img src="%s" alt="%s" class="theme-product-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) ); ?>
                                                </a>
                                                <a href="http://shopex.test/product/%d8%af%d9%88%d8%b1%d9%87-%d9%87%d9%88%d8%b4-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c/">محصول تست</a>
                                            </div>

                                            <div class="product-remove">
                                                <a href="http://shopex.test/cart/?remove_item=fa2e8c4385712f9a1d24c363a2cbe5b8&amp;_wpnonce=4a1ce459d6" class="remove" aria-label="دوره هوش تجاری را از سبد خرید حذف کنید" data-product_id="2720" data-product_sku=""><i aria-hidden="true" class="isax isax-trash"></i></a>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="product-quantity" data-title="تعداد">
                                                <div class="quantity">
                                                    <label class="screen-reader-text" for="quantity_66bddfe92e982">محصول تست عدد</label>
                                                    <button type="button" class="plus">+</button>
                                                    <input
                                                        type="number"
                                                        id="quantity_66bddfe92e982"
                                                        class="input-text qty text"
                                                        name="cart[fa2e8c4385712f9a1d24c363a2cbe5b8][qty]"
                                                        value="2"
                                                        aria-label="تعداد محصول"
                                                        size="4"
                                                        min="0"
                                                        max=""
                                                        step="1"
                                                        placeholder=""
                                                        inputmode="numeric"
                                                        autocomplete="off"
                                                    />
                                                    <button type="button" class="minus">-</button>
                                                </div>
                                            </div>

                                            <div class="product-price" data-title="قیمت">
                                                <p class="discount-percentage">25%</p>
                                            </div>

                                            <div class="product-subtotal" data-title="جمع فرعی">
                                                <p class="real-price">8000000</p>
                                                <span class="woocommerce-Price-amount amount">
                                                    <bdi>6،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between price-containers">
                                        <div class="price-container d-flex flex-column">
                                            <p class="price-tag">قیمت</p>
                                            <div class="price-values d-flex flex-row">
                                                <p class="price-value">6000000</p>
                                                <p class="price-unit">تومان</p>
                                            </div>
                                        </div>
                                        <a type="submit" class="cart-btn button redirect-to-cart" href="http://shopex.test/cart/">ثبت سفارش</a>

                                        <input type="hidden" id="woocommerce-cart-nonce" name="woocommerce-cart-nonce" value="4a1ce459d6" />
                                        <input type="hidden" name="_wp_http_referer" value="/product/%D8%AF%D9%88%D8%B1%D9%87-%D9%87%D9%88%D8%B4-%D8%AA%D8%AC%D8%A7%D8%B1%DB%8C/" />
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>

                    <?php

                }
                else{                 

                    if ( WC()->cart->is_empty() ) {
                        echo '<p class="empty">' . esc_html__( 'cart is empty', THEME_NAME ) . '</p>';
                    }
                    else{
                        $cart = WC()->cart;
                        ?>

                            <form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

                                <div class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">

                                    <?php
                                    $total_cart = 0;
                                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                        $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                        $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                                        $product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );

                                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                                            $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                                            ?>
                                            <div class="p-2 woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="d-flex align-items-center product-name" data-title="<?php esc_attr_e( 'Product', THEME_NAME ); ?>">
                                                        <?php
                                                        $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

                                                        if ( ! $product_permalink ) {
                                                            echo $thumbnail; // PHPCS: XSS ok.
                                                        } else {
                                                            printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
                                                        }
                                                        if ( ! $product_permalink ) {
                                                            echo wp_kses_post( $product_name . '&nbsp;' );
                                                        } else {
                                                            /**
                                                             * This filter is documented above.
                                                             *
                                                             * @since 2.1.0
                                                             */
                                                            echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
                                                        }

                                                        do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

                                                        // Meta data.
                                                        echo wc_get_formatted_cart_item_data( $cart_item ); // PHPCS: XSS ok.

                                                        // Backorder notification.
                                                        if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
                                                            echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', THEME_NAME ) . '</p>', $product_id ) );
                                                        }
                                                        ?>
                                                    </div>

                                                    <div class="product-remove">
                                                        <?php
                                                            echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                                'woocommerce_cart_item_remove_link',
                                                                sprintf(
                                                                    '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><i aria-hidden="true" class="isax isax-trash"></i></a>',
                                                                    esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                                                                    /* translators: %s is the product name */
                                                                    esc_attr( sprintf( __( 'Remove %s from cart', THEME_NAME ), wp_strip_all_tags( $product_name ) ) ),
                                                                    esc_attr( $product_id ),
                                                                    esc_attr( $_product->get_sku() )
                                                                ),
                                                                $cart_item_key
                                                            );
                                                        ?>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', THEME_NAME ); ?>">
                                                        <?php
                                                        if ( $_product->is_sold_individually() ) {
                                                            $min_quantity = 1;
                                                            $max_quantity = 1;
                                                        } else {
                                                            $min_quantity = 0;
                                                            $max_quantity = $_product->get_max_purchase_quantity();
                                                        }

                                                        $product_quantity = woocommerce_quantity_input(
                                                            array(
                                                                'input_name'   => "cart[{$cart_item_key}][qty]",
                                                                'input_value'  => $cart_item['quantity'],
                                                                'max_value'    => $max_quantity,
                                                                'min_value'    => $min_quantity,
                                                                'product_name' => $product_name,
                                                            ),
                                                            $_product,
                                                            false
                                                        );

                                                        echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                                                        ?>
                                                    </div>

                                                    <div class="product-price" data-title="<?php esc_attr_e( 'Price', THEME_NAME ); ?>">
                                                        <?php
                                                            // Get regular price and sale price
                                                            $regular_price = $_product->get_regular_price();
                                                            $sale_price = $_product->get_sale_price();

                                                            // Calculate discount percentage
                                                            if ($regular_price && $sale_price) {
                                                                $discount_percentage = round(100 - (($sale_price / $regular_price) * 100)) . '%';
                                                                echo '<p class="discount-percentage">' . $discount_percentage . '</p>';
                                                                $total_cart += $sale_price*$cart_item['quantity'];
                                                            }else{
                                                                $total_cart += $regular_price*$cart_item['quantity'];
                                                            }
                                                        ?>
                                                    </div>

                                                    <div class="product-subtotal" data-title="<?php esc_attr_e( 'Subtotal', THEME_NAME ); ?>">
                                                        <?php
                                                            if ($sale_price) {
                                                                $real_price = $cart_item['quantity'] * $regular_price;
                                                                echo '<p class="real-price">' . $real_price . '</p>';
                                                            }
                                                            echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>

                                    <?php do_action( 'woocommerce_cart_contents' ); ?>

                                <div class="d-flex justify-content-between price-containers">
                                    <div class="price-container d-flex flex-column">
                                        <p class="price-tag"><?php
                                        echo __( "price", THEME_NAME );
                                        ?>
                                        </p>
                                        <div class="price-values d-flex flex-row">
                                            <p class="price-value"><?php
                                                echo $total_cart;
                                            ?></p>
                                            <p class="price-unit"><?php
                                                $currency_symbol = get_woocommerce_currency_symbol();
                                                echo $currency_symbol;
                                            ?></p>
                                        </div>
                                    </div>
                                    <a type="submit" class="cart-btn button redirect-to-cart" href="<?php echo esc_url( wc_get_cart_url() ); ?>"><?php 
                                        echo __( "set Order", THEME_NAME );
                                    ?></a>

                                    <?php do_action( 'woocommerce_cart_actions' ); ?>

                                    <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
                                </div>
                            </div>
                        </form>
                        <script>
                            jQuery(document).ready(function($){
                                var woocommerce_form = $( '.single-share-box-container form' );
                                woocommerce_form.on('change', '.qty', function(){
                                    form = $(this).closest('form');

                                    // emulates button Update cart click
                                    $("<input type='hidden' name='update_cart' id='update_cart' value='1'>").appendTo(form);

                                    // get the form data before disable button...
                                    formData = form.serialize();

                                    $("a.redirect-to-cart").addClass('disabled').html('<?php echo __('Updating…', THEME_NAME) ?>');

                                    // update cart via ajax
                                    $.post( form.attr('action'), formData, function(resp) {
                                        // get updated data on response cart
                                        setTimeout(function() {
                                            location.reload(); // Reload the current page
                                        }, 0);
                                    });
                                })
                            });
                        </script>
                    <?php
                    }

                }
                ?>
            </div>
        </div>
        <?php
	}
}