<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_invoice extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_invoice';
    }

    public function get_title() {
        return esc_html__('product Invoice', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_invoice';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_content_section_1() {
		$this->start_controls_section(
			'section_address',
			[ 
				'label' => __( 'address', THEME_NAME ),
			]
		);

		$this->add_control(
			'billing_address',
			[ 
				'label' => esc_html__( 'show billing address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'billing_address_label',
			[ 
				'label' => __( 'billing address text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'billing address', THEME_NAME ),
				'condition' => [ 
					'billing_address' => 'yes',
				],
			]
		);

		$this->add_control(
			'shipping_address',
			[ 
				'label' => esc_html__( 'show shipping address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'shipping_address_label',
			[ 
				'label' => __( 'shipping address text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'shipping address', THEME_NAME ),
				'condition' => [ 
					'shipping_address' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_content_section_2() {
		$this->start_controls_section(
			'section_items',
			[ 
				'label' => __( 'items', THEME_NAME ),
			]
		);

		$this->add_control(
			'invoice_date',
			[ 
				'label' => esc_html__( 'show invoice date', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'invoice_date_label',
			[ 
				'label' => __( 'invoice date text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'invoice date', THEME_NAME ),
				'condition' => [ 
					'invoice_date' => 'yes',
				],
			]
		);

		$this->add_control(
			'order_number',
			[ 
				'label' => esc_html__( 'show order number', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'order_number_label',
			[ 
				'label' => __( 'order number text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'order number', THEME_NAME ),
				'condition' => [ 
					'order_number' => 'yes',
				],
			]
		);

		$this->add_control(
			'order_date',
			[ 
				'label' => esc_html__( 'show order date', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'order_date_label',
			[ 
				'label' => __( 'order date text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'order date', THEME_NAME ),
				'condition' => [ 
					'order_date' => 'yes',
				],
			]
		);

		$this->add_control(
			'payment_method',
			[ 
				'label' => esc_html__( 'show payment method', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'payment_method_label',
			[ 
				'label' => __( 'payment method text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'payment method', THEME_NAME ),
				'condition' => [ 
					'payment_method' => 'yes',
				],
			]
		);

		$this->add_control(
			'billing_email',
			[ 
				'label' => esc_html__( 'show billing email', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

        $this->add_control(
			'billing_email_label',
			[ 
				'label' => __( 'billing email text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'email', THEME_NAME ),
				'condition' => [ 
					'billing_email' => 'yes',
				],
			]
		);

		$this->add_control(
			'billing_phone',
			[ 
				'label' => esc_html__( 'show billing phone', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'billing_phone_label',
			[ 
				'label' => __( 'billing phone text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'phone', THEME_NAME ),
				'condition' => [ 
					'billing_phone' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

    protected function register_content_section_3() {
		$this->start_controls_section(
			'section_product_table',
			[ 
				'label' => __( 'product table', THEME_NAME ),
			]
		);

		$this->add_control(
			'product_image',
			[ 
				'label' => esc_html__( 'show product image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_image_label',
			[ 
				'label' => __( 'product image text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'image', THEME_NAME ),
				'condition' => [ 
					'product_image' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_name',
			[ 
				'label' => esc_html__( 'show product name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_name_label',
			[ 
				'label' => __( 'product name text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'product', THEME_NAME ),
				'condition' => [ 
					'product_name' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_sku',
			[ 
				'label' => esc_html__( 'show product sku', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [ 
					'product_name' => 'yes',
				]
			]
		);

		$this->add_control(
			'product_sku_label',
			[ 
				'label' => __( 'product sku text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'sku', THEME_NAME ),
				'condition' => [ 
					'product_name' => 'yes',
					'product_sku' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_attributes',
			[ 
				'label' => esc_html__( 'show product attributes', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [ 
					'product_name' => 'yes',
				]
			]
		);

		$this->add_control(
			'product_attributes_label',
			[ 
				'label' => __( 'product attributes text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'attributes', THEME_NAME ),
				'condition' => [ 
					'product_name' => 'yes',
					'product_attributes' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_weight',
			[ 
				'label' => esc_html__( 'show product weight', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [ 
					'product_name' => 'yes',
				]
			]
		);

		$this->add_control(
			'product_weight_label',
			[ 
				'label' => __( 'product weight text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'weight', THEME_NAME ),
				'condition' => [ 
					'product_name' => 'yes',
					'product_weight' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_dimensions',
			[ 
				'label' => esc_html__( 'show product dimensions', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [ 
					'product_name' => 'yes',
				]
			]
		);

		$this->add_control(
			'product_dimensions_label',
			[ 
				'label' => __( 'product dimensions text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'dimensions', THEME_NAME ),
				'condition' => [ 
					'product_name' => 'yes',
					'product_dimensions' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_category',
			[ 
				'label' => esc_html__( 'show product category', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_category_label',
			[ 
				'label' => __( 'product category text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'category', THEME_NAME ),
			]
		);

		$this->add_control(
			'product_price',
			[ 
				'label' => esc_html__( 'show product price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_price_label',
			[ 
				'label' => __( 'product price text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'price', THEME_NAME ),
				'condition' => [ 
					'product_price' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_quantity',
			[ 
				'label' => esc_html__( 'show product quantity', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_quantity_label',
			[ 
				'label' => __( 'product quantity text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'quantity', THEME_NAME ),
				'condition' => [ 
					'product_quantity' => 'yes',
				],
			]
		);

		$this->add_control(
			'discount_applied',
			[ 
				'label' => esc_html__( 'show discount', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'discount_applied_label',
			[ 
				'label' => __( 'discount text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'discount', THEME_NAME ),
				'condition' => [ 
					'discount_applied' => 'yes',
				],
			]
		);

		$this->add_control(
			'product_total',
			[ 
				'label' => esc_html__( 'show product total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_total_label',
			[ 
				'label' => __( 'product total text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'total', THEME_NAME ),
				'condition' => [ 
					'product_total' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_content_section_4() {
		$this->start_controls_section(
			'section_order_notes',
			[ 
				'label' => __( 'order notes', THEME_NAME ),
			]
		);

		$this->add_control(
			'order_notes',
			[ 
				'label' => esc_html__( 'show order notes', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'order_notes_label',
			[ 
				'label' => __( 'order notes text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'order notes', THEME_NAME ),
				'condition' => [ 
					'order_notes' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

    protected function register_style_section_1() {
        $this->start_controls_section(
            'address_section',
            [
                'label' => esc_html__( 'address', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('order-addresses',  '.order-addresses');

		$this->add_control(
			'billing-address-body-sep',
			[ 
				'label' => esc_html__( 'billing address body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'billing-address', '.billing-address' );

		$this->add_control(
			'billing-address-title-sep',
			[ 
				'label' => esc_html__( 'billing address title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'billing-address-h3', '.billing-address h3' );

		$this->add_control(
			'billing-address-sep',
			[ 
				'label' => esc_html__( 'billing address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'billing-address-address', '.billing-address address' );

		$this->add_control(
			'shipping-address-body-sep',
			[ 
				'label' => esc_html__( 'shipping address body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'shipping-address', '.shipping-address' );

		$this->add_control(
			'shipping-address-title-sep',
			[ 
				'label' => esc_html__( 'shipping address title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'shipping-address-address', '.shipping-address h3' );

		$this->add_control(
			'shipping-address-sep',
			[ 
				'label' => esc_html__( 'shipping address', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'shipping-address-h3', '.shipping-address address' );


		$this->end_controls_section();

    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'info_list_section',
			[ 
				'label' => esc_html__( 'info', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'info-list', '.info-list' );

		$this->add_control(
			'info_list_li_sep',
			[ 
				'label' => esc_html__( 'info item', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'info_list_li', '.info-list li' );

		$this->add_control(
			'li_title_sep',
			[ 
				'label' => esc_html__( 'info title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'li_title', '.info-list .li-title' );

		$this->add_control(
			'li_value_sep',
			[ 
				'label' => esc_html__( 'info value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'li_value', '.info-list .li-value' );

		
		
		$this->end_controls_section();

	}

    protected function register_style_section_3() {
		$this->start_controls_section(
			'table_section',
			[ 
				'label' => esc_html__( 'table', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->register_table_style('table',  'table');

        $this->end_controls_section();
    }

	protected function register_style_section_4() {
		$this->start_controls_section(
			'table_header_section',
			[ 
				'label' => esc_html__( 'table header', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'head-image-sep',
			[ 
				'label' => esc_html__( 'iamge', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-image', '.head-image' );

		$this->add_control(
			'head-name-sep',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-name', '.head-name' );


        $this->add_control(
			'head-item-category-sep',
			[ 
				'label' => esc_html__( 'category', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-item-category', '.head-item-category' );

        $this->add_control(
			'head-item-price-sep',
			[ 
				'label' => esc_html__( 'price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-item-price', '.head-item-price' );

		$this->add_control(
			'head-item-applied-sep',
			[ 
				'label' => esc_html__( 'applied', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-item-applied', '.head-applied' );

		$this->add_control(
			'head-quantity-sep',
			[ 
				'label' => esc_html__( 'quantity', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-quantity', '.head-quantity' );

		$this->add_control(
			'head-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'head-total', '.head-total' );


		$this->end_controls_section();
	}

	protected function register_style_section_5() {
		$this->start_controls_section(
			'table_body_section',
			[ 
				'label' => esc_html__( 'table body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'product-image-body-sep',
			[ 
				'label' => esc_html__( 'iamge body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-image', '.product-image' );


        $this->add_control(
			'product-image-sep',
			[ 
				'label' => esc_html__( 'iamge', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'product-image', '.product-image img' );


		$this->add_control(
			'product-name-sep',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-name', '.product-name .name' );

        $this->add_control(
			'product-sub-item-sep',
			[ 
				'label' => esc_html__( 'product sub item title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-sub-item-title', '.product-sub-item' );

		$this->add_control(
			'product-sub-value-sep',
			[ 
				'label' => esc_html__( 'product sub item value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-sub-item-value', '.product-sub-value' );


		$this->add_control(
			'product-category-sep',
			[ 
				'label' => esc_html__( 'category', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-category', '.product-category' );

		$this->add_control(
			'product-item-price-sep',
			[ 
				'label' => esc_html__( 'price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-item-rice', '.product-item-price' );

		$this->add_control(
			'product-sep',
			[ 
				'label' => esc_html__( 'discount', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-discount', '.product-discount' );

		$this->add_control(
			'product-quantity-sep',
			[ 
				'label' => esc_html__( 'quantity', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-quantity', '.product-quantity' );

		$this->add_control(
			'product-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'product-total', '.product-price' );


		$this->end_controls_section();
	}

	protected function register_style_section_6() {
		$this->start_controls_section(
			'table_footer_section',
			[ 
				'label' => esc_html__( 'table footer', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'total-name-sep',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'total-name', '.total-name' );

		$this->add_control(
			'total-quantity-sep',
			[ 
				'label' => esc_html__( 'quantity', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'total-quantity', '.total-quantity' );

		$this->add_control(
			'total-price-sep',
			[ 
				'label' => esc_html__( 'price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'total-price', '.total-price' );
	

		$this->end_controls_section();
	}

	protected function register_style_section_7() {
		$this->start_controls_section(
			'order-notes_section',
			[ 
				'label' => esc_html__( 'order notes', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'order-notes-sep',
			[ 
				'label' => esc_html__( 'order notes body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'order-notes', '.order-notes' );

		$this->add_control(
			'order-notes-title-sep',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'order-notes-title', '.order-notes-title' );

		$this->add_control(
			'order-notes-value-sep',
			[ 
				'label' => esc_html__( 'value', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'order-notes-value', '.order-notes-value' );


		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_content_section_1();
		$this->register_content_section_2();
		$this->register_content_section_3();
		$this->register_content_section_4();
		$this->register_style_section_1();
		$this->register_style_section_2();
		// $this->register_style_section_3();
		$this->register_style_section_4();
		$this->register_style_section_5();
		$this->register_style_section_6();
		$this->register_style_section_7();
	}

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		$settings = $this->get_settings();
		if ( $this->theme_is_edit_mode() ) {
			$orders = wc_get_orders( array(
				'limit' => 1,
				'orderby' => 'date',
				'order' => 'ASC',
			) );
            ?>
            	<link rel="stylesheet" href="<?php echo esc_url( get_template_directory_uri() . '/include/ar_invoices/templates/simple-style.css' ) ?>" type="text/css" media="screen,print" />
                <style>
                    body{
                        padding: 0;
                    }
                </style>
            <?php
		}
        else{
            $orders = ar_invoice_get_orders();
        }
		if ( $orders ) :
			foreach ( $orders as $order_obj ) :
				?>
                <article class="content">
                    <div class="order-addresses">
                        <?php
                        if ( $settings['billing_address'] === 'yes' ) {
                            ?>
                            <div class="billing-address">
                                <h3>
                                    <?php
									echo $settings['billing_address_label'];
                                    ?>
                                    </h3>
                                <address>
                                    <?php
                                    if ( ! $order_obj->get_formatted_billing_address() ) {
                                        esc_attr_e( 'N/A', THEME_NAME );
                                    } else {
                                        echo wp_kses_post( apply_filters( 'ar_invoice_address_billing', $order_obj->get_formatted_billing_address(), $order_obj ) );
                                        $wdn_order_billing_id = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_email() : $order_obj->billing_email;
                                        $wdn_order_billing_phone = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_phone() : $order_obj->billing_phone;
                                        if ( $wdn_order_billing_phone ) {
                                            echo '<br>';
                                            echo $wdn_order_billing_phone; // phpcs:ignore
                                        }
                                        if ( $wdn_order_billing_id ) {
                                            echo '<br>';
                                            echo $wdn_order_billing_id; // phpcs:ignore
                                        }
                                    }
                                    ?>
                                </address>
                            </div>
                        <?php } 
                        if ( $settings['shipping_address'] === 'yes' ) {
                            ?>
                            <div class="shipping-address">
                                <h3>
                                    <?php
                                        echo $settings['shipping_address_label'];
                                    ?>
                                </h3>
                                <address>
                                    <?php
                                    if ( ! $order_obj->get_formatted_shipping_address() ) {
                                        esc_attr_e( 'N/A', THEME_NAME );
                                    } else {
                                        echo wp_kses_post( apply_filters( 'ar_invoice_address_shipping', $order_obj->get_formatted_shipping_address(), $order_obj ) );
                                        $wdn_order_billing_id = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_email() : $order_obj->billing_email;
                                        $wdn_order_billing_phone = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_phone() : $order_obj->billing_phone;
                                        if ( $wdn_order_billing_phone ) {
                                            echo '<br>';
                                            echo $wdn_order_billing_phone; // phpcs:ignore
                                        }
                                        if ( $wdn_order_billing_id ) {
                                            echo '<br>';
                                            echo $wdn_order_billing_id; // phpcs:ignore
                                        }
                                    }
                                    ?>
                                </address>
                            </div>
                        <?php } ?>
					</div><!-- .order-addresses -->
					
					<div class="order-info">
						<ul class="info-list">
							<?php
							if ( $settings['invoice_date'] === 'yes' ) {
								$label = $settings['invoice_date_label'];
								global $ar_invoices_instance;
								$wdn_order_id = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_id() : $order_obj->id;
								$value = convert_date( $ar_invoices_instance->print->get_order_invoice_date( $wdn_order_id ), 'j F Y' );

								?>
                                <li>
                                    <strong class="li-title"><?php echo wp_kses_post( $label ); ?></strong>
									<strong class="li-value"><?php echo wp_kses_post( $value ); ?></strong>
                                </li>
                                <?php
							}
							if ( $settings['order_number'] === 'yes' ) {
								$label = $settings['order_number_label'];
								$value = $order_obj->get_order_number();
								?>
                                <li>
                                    <strong class="li-title"><?php echo wp_kses_post( $label ); ?></strong>
                                    <strong class="li-value"><?php echo wp_kses_post( $value ); ?></strong>
                                </li>
                                <?php
							}
                            if ( $settings['order_date'] === 'yes' ) {
								$label = $settings['order_date_label'];
								$value = convert_date( ! is_null( $order_obj->get_date_created() ) ? $order_obj->get_date_created()->getOffsetTimestamp() : '', 'j F Y' );
								?>
                                <li>
                                    <strong class="li-title"><?php echo wp_kses_post( $label ); ?></strong>
                                    <strong class="li-value"><?php echo wp_kses_post( $value ); ?></strong>
                                </li>
                                <?php
							}
                            if ( $settings['billing_email'] === 'yes' ) {
								$label = $settings['billing_email_label'];
								$value = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_email() : $order_obj->billing_email;
								if ( $value ) {
									?>
                                    <li>
                                        <strong class="li-title"><?php echo wp_kses_post( $label ); ?></strong>
                                        <strong class="li-value"><?php echo wp_kses_post( $value ); ?></strong>
                                    </li>
                                    <?php
								}
							}
                            if ( $settings['billing_phone'] === 'yes' ) {
								$label = $settings['billing_phone_label'];
								$value = ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_billing_phone() : $order_obj->billing_phone;
								if ( $value ) {
									?>
                                    <li>
                                        <strong class="li-title"><?php echo wp_kses_post( $label ); ?></strong>
                                        <strong class="li-value"><?php echo wp_kses_post( $value ); ?></strong>
                                    </li>
                                    <?php
								}
							}
                            ?>
						</ul>
					
					</div><!-- .order-info -->
					
					<div class="order-items">
						<table>
							<thead>
								<tr>
                                    <?php
                                    if ( $settings['product_image'] === 'yes' ) { ?>
                                        <th class="head-image"><span><?php echo $settings['product_image_label']; ?></span></th>
                                    <?php }
                                    if ( $settings['product_name'] === 'yes' ) { ?>
									<th class="head-name"><span><?php echo $settings['product_name_label']; ?></span></th>
                                    <?php }
									if ( $settings['product_category'] === 'yes' ) { ?>
										<th class="head-item-category"><span><?php echo $settings['product_category_label']; ?></span></th>
									<?php }
                                    if ( $settings['product_price'] === 'yes' ) { ?>
									<th class="head-item-price"><span><?php echo $settings['product_price_label']; ?></span></th>
                                    <?php }
									if ( $settings['discount_applied'] === 'yes' ) { ?>
										<th class="head-applied"><span><?php echo $settings['discount_applied_label']; ?></span></th>
									<?php }
                                    if ( $settings['product_quantity'] === 'yes' ) { ?>
									<th class="head-quantity"><span><?php echo $settings['product_quantity_label']; ?></span></th>
                                    <?php }
                                    if ( $settings['product_total'] === 'yes' ) { ?>
									<th class="head-total"><span><?php echo $settings['product_total_label']; ?></span></th>
                                    <?php } ?>

								</tr>
							</thead>
					
							<tbody>
								<?php
								if ( count( $order_obj->get_items() ) > 0 ) :

									?>
									<?php foreach ( $order_obj->get_items() as $item_id => $item ) :
										$product = wc_get_product( $item['product_id'] );
										?>
										<tr>
                                            <?php
											if ( $settings['product_image'] === 'yes' ) { ?>
                                                <td class="product-image">
                                                    <?php
													if ( $product ) {
														if ( has_post_thumbnail( $product->get_id() ) ) {
															echo $product->get_image( 'thumbnail' );
														}
													}?>
                                                </td>
                                            <?php }
											if ( $settings['product_name'] === 'yes' ) { ?>
                                                <td class="product-name">
                                                    <div class="name">
                                                        <?php echo esc_html( $item['name'] ); ?>
													</div>
													<dl class="extras">
                                                        <?php
                                                        if ( $product && $product->exists() && $product->is_downloadable() && $order_obj->is_download_permitted() ) :
                                                            ?>
                                                            <dt>
                                                            <?php esc_attr_e( 'Download:', THEME_NAME );  ?>
                                                            </dt>
                                                            <dd>
                                                            <?php printf( esc_attr__( '%s Files', THEME_NAME ), count( $item->get_item_downloads() ) );  ?>
                                                            </dd>
                                                            <br>
                                                        <?php
                                                        endif;
                                                        if ( $settings['product_sku'] === 'yes' ) { ?>
                                                            <dt class="product-sub-item">
                                                                <?php echo esc_html($settings['product_sku_label']); ?>
                                                            </dt>
                                                            <dd class="product-sub-value">
                                                                <?php
																if ( $product ) {
																	echo esc_html( $product->get_sku() );
																}?>
                                                            </dd>
                                                            <br>
                                                        <?php }
                                                        if ( $settings['product_attributes'] === 'yes' ) { ?>
                                                            <dt class="product-sub-item">
                                                                <?php echo esc_html( $settings['product_attributes_label'] ); ?>
                                                            </dt>
                                                            <br>
                                                            <dd class="product-sub-value">
                                                                <?php
																if ( $product ) {
																	$attributes = $product->get_attributes();
																	if ( ! empty( $attributes ) ) {
																		foreach ( $attributes as $attribute ) {
																			$options = $attribute->get_options();

																			$attribute_values = [];
																			if ( $attribute->is_taxonomy() ) {
																				$terms = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'names' ) );
																				$attribute_values = array_map( 'wp_kses_post', $terms );
																			} else {
																				// If it's not taxonomy-based, just output the options as they are
																				$attribute_values = array_map( 'wp_kses_post', $options );
																			}
																			echo esc_html( wc_attribute_label( $attribute->get_name() ) . ': ' . implode( ', ', $attribute_values ) ) . '<br>';
																		}
																	}
																}
                                                                    ?>
                                                            </dd>
                                                            <br>
                                                        <?php }
                                                        if ( $product ) {
                                                            if ( $settings['product_weight'] === 'yes' && $product->has_weight() ) { ?>
                                                                <dt class="product-sub-item">
                                                                    <?php echo esc_html( $settings['product_weight_label'] ); ?>
                                                                </dt>
                                                                <dd class="product-sub-value">
                                                                    <?php
                                                                        echo esc_html( $product->get_weight() ) . ' ' . get_option( 'woocommerce_weight_unit' );
                                                                    ?>
                                                                </dd>
                                                                <br>
                                                            <?php }
                                                        }
														if ( $product ) {
                                                            if ( $settings['product_dimensions'] === 'yes' && $product->has_dimensions() ) { ?>
                                                                <dt class="product-sub-item">
                                                                    <?php echo esc_html( $settings['product_dimensions_label'] ); ?>
                                                                </dt>
                                                                <dd class="product-sub-value">
                                                                    <?php
                                                                    
                                                                        echo esc_html( $product->get_dimensions() );
                                                                    ?>
                                                                </dd>
                                                                <br>
                                                            <?php }
														}?>
                                                    </dl>
                                                </td>
                                            <?php }
                                            if ( $settings['product_category'] === 'yes' ) { ?>
                                                <td class="product-category">
                                                    <?php
													if ( $product ) {
														echo ( wc_get_product_category_list( $product->get_id() ) );
													} ?>
                                                </td>
                                            <?php }
                                            if ( $settings['product_price'] === 'yes' ) { ?>
                                                <td class="product-item-price">
                                                    <span><?php echo wp_kses_post( ar_invoice_get_formatted_item_price( $order_obj, $item ) ); ?></span>
                                                </td>
                                            <?php }
                                            if ( $settings['discount_applied'] === 'yes' ) { ?>
                                                <td class="product-discount">
                                                    <?php if ($item->get_subtotal() > $item->get_total()){ ?>
                                                    <span><?php echo esc_html( wc_price( $item->get_subtotal() - $item->get_total() ) ); ?></span>
                                                    <?php } ?>
                                                </td>
                                            <?php }
                                            if ( $settings['product_quantity'] === 'yes' ) { ?>
                                                <td class="product-quantity">
                                                    <span><?php echo esc_attr( $item['qty'] ); ?></span>
                                                </td>
                                            <?php }
                                            if ( $settings['product_total'] === 'yes' ) { ?>
                                                <td class="product-price">
                                                    <span><?php echo wp_kses_post( $order_obj->get_formatted_line_subtotal( $item ) ); ?></span>
                                                </td>
                                            <?php } ?>

										</tr>
									<?php endforeach; ?>
								<?php endif; ?>
							</tbody>
					
							<tfoot>
								<?php
								$totals_arr = $order_obj->get_order_item_totals();
								if ( $totals_arr ) :
                                    
									foreach ( $totals_arr as $total ) :
										?>
										<tr>
											<td class="total-name" colspan="2"><span><?php echo wp_kses_post( $total['label'] ); ?></span></td>
                                            <?php
                                           
											if ( $settings['product_quantity'] === 'yes' ) {
                                                if ( 'جمع جزء' === $total['label'] ) { ?>
                                                    <td class="total-quantity"><?php echo __('count: ', THEME_NAME) . wp_kses_post( $order_obj->get_item_count() ); ?></td>
                                                <?php } else { ?>
                                                    <td class="total-quantity"></td>
                                                <?php } 
                                            }?>

											<td class="total-price"><span><?php echo wp_kses_post( $total['value'] ); ?></span></td>
										</tr>
									<?php endforeach; ?>
								<?php endif; ?>
							</tfoot>
						</table>
					
					</div><!-- .order-items -->
                    <?php 
                    if ( $settings['order_notes'] === 'yes' ) { ?>
					<div class="order-notes">
                        <p class="order-notes-title">
                            <?php
                            echo $settings['order_notes_label']; ?>
                        </p>
                        <p class="order-notes-value">
                            <?php 
                                echo stripslashes( wpautop( wptexturize( ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', '>=' ) ) ? $order_obj->get_customer_note() : $order_obj->customer_note ) ) );
                            ?>
                        </p>
					</div><!-- .order-notes -->
					 <?php } ?>
				
                </article><!-- .content -->

            <?php endforeach; ?>
		<?php endif;
	}

}