<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class ar_post_table_content extends \Elementor\Widget_Base {

	use basic_element;

	public function get_name() {
		return 'ar_post_table_content';
	}

	public function get_title() {
		return __( 'table of content', THEME_NAME );
	}

	public function get_icon() {
		return 'ar_post_table_content';
	}

	public function get_categories() {
		return [ 'core-elementor-elements' ];
	}

	protected function register_content_section_1() {
		$this->start_controls_section(
			'table_of_contents',
			[ 
				'label' => esc_html__( 'Table of Contents', THEME_NAME ),
			]
		);

		$this->add_control(
			'headings_by_tags',
			[ 
				'label' => esc_html__( 'Anchors By Tags', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'default' => [ 'h2', 'h3', 'h4', 'h5', 'h6' ],
				'options' => [ 
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'label_block' => true,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'container',
			[ 
				'label' => esc_html__( 'Container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->end_controls_section();
	}

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style_items',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_text_style( 'empty', 'li' );

		$this->end_controls_section();
	}

	protected function register_controls() {
		$this->register_content_section_1();
		$this->register_style_section_1();
	}

	protected function render() {
        
		$settings = $this->get_settings_for_display();
        ?>
        <div class="toc-container">
            <!-- Table of Contents will be dynamically generated here -->
        </div>
        <script>
            // JavaScript function to generate Table of Contents (TOC) based on headings
            function generateTableOfContents(containerSelector, tocSelector, headingsSelector) {
                const container = document.querySelector(containerSelector);
                if (!container) return;

                const toc = document.querySelector(tocSelector);
                if (!toc) return;

                const headings = container.querySelectorAll(headingsSelector);

                if (headings.length === 0) {
                    toc.style.display = 'none'; // Hide TOC if no headings found
                    return;
                }

                const tocList = document.createElement('ul');
                tocList.classList.add('toc-list');

                headings.forEach((heading) => {
                    const id = heading.id;
                    const title = heading.textContent;
                    const listItem = document.createElement('li');
                    const link = document.createElement('a');

                    link.href = `#${id}`;
                    link.textContent = title;
                    link.addEventListener('click', (e) => {
                        e.preventDefault();
                        document.querySelector(`#${id}`).scrollIntoView({ behavior: 'smooth' });
                    });

                    listItem.appendChild(link);
                    tocList.appendChild(listItem);
                });

                toc.appendChild(tocList);
            }
            // Initialize Table of Contents (TOC) generation on page load or widget render
            jQuery(document).ready(function($) {
                    var selectedTags = <?php echo json_encode( $settings['headings_by_tags'] ); ?>;

					var headingsSelector = selectedTags.map( tag => tag.toLowerCase() ).join( ', ' );

					generateTableOfContents(
						'.<?php echo $settings['container'] ?> .elementor-widget-container', // Selector for post content container
                        '.toc-container', // Selector for TOC container
                        headingsSelector // Use selected heading tags for TOC generation
                    );
                } );

        </script>
		<?php
	}
}
