<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_quote extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_quote';
    }

    public function get_title() {
        return esc_html__('post quote', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_quote';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_quote',  'p.selected_attribute_value');

        $this->end_controls_section();

    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'post_style_section_auther',
			[ 
				'label' => esc_html__( 'auther', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'post_quote_auther', 'p.selected_attribute_value_2' );

		$this->end_controls_section();

	}

	protected function register_controls() {

        $this->register_style_section_1();
		$this->register_style_section_2();
    }

    protected function render() {
		$post_kind = get_post_type();
		$selected_attribute_key = $post_kind . '_single_quote_content';
		$selected_attribute_key_2 = $post_kind . '_single_quote_author';
		$selected_attribute_value = '';
		$selected_attribute_value_2 = '';

		if ( $this->theme_is_edit_mode() ) {
            $selected_attribute_value = __( "sample quote", THEME_NAME );
			$selected_attribute_value_2 = __( "auther", THEME_NAME );
		} else {
			if ( ! empty( $selected_attribute_key ) ) {
				$selected_attribute_value = get_post_meta( get_the_ID(), $selected_attribute_key, true );
				$selected_attribute_value_2 = get_post_meta( get_the_ID(), $selected_attribute_key_2, true );
			}
		}

		echo '<p class="selected_attribute_value">' . $selected_attribute_value . '</p>';
		echo '<p class="selected_attribute_value_2">' . $selected_attribute_value_2 . '</p>';
    }


}