<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_image extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_image';
    }

    public function get_title() {
        return esc_html__('post image', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_image';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'image', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'image_link',
			[ 
				'label' => esc_html__( 'add link to image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[ 
				'name' => 'thumbnail',
				'exclude' => [ 'custom' ],
				'default' => 'medium',
				'dynamic' => [ 
					'active' => true,
				]
			]
		);

        $this->start_controls_tabs( 'image-style' );

        $this->start_controls_tab(
            'image-normal',
            [
                'label' => esc_html__( 'normal', THEME_NAME ),
            ]
        );
        $this->register_image_style('post_img',  'img');

        $this->end_controls_tab();

        $this->start_controls_tab(
            'image-hover',
            [
                'label' => esc_html__( 'hover', THEME_NAME ),
            ]
        );
        $this->register_image_style('post_img_hover',  'img:hover');

        $this->end_controls_tab();


        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $image_link_enabled = !empty($settings['image_link']) && 'yes' === $settings['image_link'];

        if ($this->theme_is_edit_mode()) { 
            $args = array(
                'post_type'      => 'post',
                'posts_per_page' => 1, // Get only one post
                'post_status'    => 'publish',
            );

            $query = new WP_Query($args);

            if ($query->have_posts()) {
                $query->the_post();
                if (has_post_thumbnail()) {
					echo get_the_post_thumbnail( null, $settings['thumbnail_size'] );
                } else {
                    echo '<img src="' . \Elementor\Utils::get_placeholder_image_src() . '" alt="Placeholder Image">';
                }
                wp_reset_postdata();
            } else {
                echo '<img src="' . \Elementor\Utils::get_placeholder_image_src() . '" alt="Placeholder Image">';
            }
        } else {
            if (has_post_thumbnail()) {
                $post_thumbnail_id = get_post_thumbnail_id();
                if ($image_link_enabled) {
                    echo '<a href="' . esc_url(get_permalink()) . '">';
					echo wp_get_attachment_image( $post_thumbnail_id, $settings['thumbnail_size'] );
                    echo '</a>';
                } else {
					echo wp_get_attachment_image( $post_thumbnail_id, $settings['thumbnail_size'] );
                }
            } else {
                echo esc_html__('No featured image found.', THEME_NAME);
            }
        }
    }
}