<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_excerpt extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_excerpt';
    }

    public function get_title() {
        return esc_html__('post excerpt', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_excerpt';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __( 'Excerpt Length', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 20, 
                'description' => __( 'Set the maximum number of words for the excerpt.', THEME_NAME ),
            ]
        );

        $this->register_text_style('post_categories',  '.post-excerpt');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $excerpt_length = ! empty( $settings['excerpt_length'] ) ? $settings['excerpt_length'] : 20;
        if ($this->theme_is_edit_mode()) {
            echo '<p class="post-excerpt">';
            $excerpt =  __('excerpt simple body, this is sample test for excerpt. here is where excerpt of post will be display, this is just simple text to show and you can adjust style and width of excerpt of post that you want to show just adjust it, it will show the post excerpt in right place', THEME_NAME);
            $excerpt = wp_trim_words( $excerpt, $excerpt_length );
			echo $excerpt;
            echo '</p>';
        } else {
            global $post;
            $excerpt = get_the_excerpt();
            $excerpt = wp_trim_words( $excerpt, $excerpt_length );
            echo '<p class="post-excerpt">';
            echo wp_kses_post( $excerpt );
            echo '</p>';
        }
    }


}