<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_category extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_category';
    }

    public function get_title() {
        return esc_html__('post category', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_category';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_comma',
            [
                'label'     => esc_html__( 'Show comma', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'separator' => 'before'
            ]
        );

        $this->register_text_style('post_categories',  'a', $align=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            ?>
			<a href="#">دسته بندی تست</a><?php if($settings['show_comma']){echo ',';}?>
            <a href="#">دسته‌بندی نشده</a><?php if($settings['show_comma']){echo ',';}?>
            <a href="#">نمونه کار تست</a>
            <?php
        } else {
            global $post;

            $post_categories = get_the_category();
            if ( !empty( $post_categories ) ) {
                $categories_list = array();
                foreach ( $post_categories as $category ) {
                    $categories_list[] = '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a>';
                }
                if($settings['show_comma']){
                    echo implode( ', ', $categories_list );
                }
                else{
                    echo $categories_list;
                }
            }
        }
    }

}