<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_page_breadcrumb extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_page_breadcrumb';
    }

    public function get_title() {
        return esc_html__('page breadcrumb', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_page_breadcrumb';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'label',
            [
                'label' => __( 'home Labels', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            'home',
            [
                'label' => __( 'home', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'home', THEME_NAME ),
            ]
        );

        $this->add_control(
            'separator',
            [
                'label' => __( 'separator', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( ' > ', THEME_NAME ),
            ]
        );

        $this->end_controls_section();

    } 
    protected function register_style_section_1() {
        $this->start_controls_section(
            'home_style_section',
            [
                'label' => esc_html__( 'home', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('home',  '.home', $align=false);

        $this->end_controls_section();

    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'links_style_section',
            [
                'label' => esc_html__( 'links', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('perma',  '.perma', $align=false);

        $this->end_controls_section();
    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'current_style_section',
            [
                'label' => esc_html__( 'current', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('current',  '.current', $align=false);

        $this->end_controls_section();
    } 

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
    }

    protected function render(){
		
	}
}