<?php

use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_image_gallery extends \Elementor\Widget_Base {

    use Post_skin_base;
    use swiper;
    use basic_element;

    public function get_name() {
        return 'ar_image_gallery';
    }

    public function get_title() {
        return esc_html__('image gallery', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_image_gallery';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'gallery',
			[ 
				'label' => esc_html__( 'image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'default Layout', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', THEME_NAME ),
                    'carousel' => esc_html__( 'Carousel', THEME_NAME ),
                ],
                'default'   => 'grid',
            ]
        );


		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_control(
			'hover',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
			]
		);

        $this->end_controls_section();
    }

	protected function register_style_section_1() {
		$this->start_controls_section( 'section_style_icons',
			[ 
				'label' => esc_html__( 'images', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->register_container_style( 'article-container', 'article' );

		$this->add_control(
			'images',
			[ 
				'label' => esc_html__( 'image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_image_style( 'article-image', 'article img');

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_style_section_1();

        $this->register_carousel_controls();
        $this->register_style_carousel_controls();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
		$widget_id = $this->get_id();
		$selected_view = $settings['layout'];
		$hover_class = $settings['hover'];
        ?>
        <div class="theme-posts-container theme-post-widget">
            <?php
                $post_wrapper_cls = '';
                if ( $selected_view !== 'carousel') {
                    $kind = 'grid';
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
                else{
                    $kind = 'carousel';
                }
                ?>
				<div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $kind ?> view-<?php echo $selected_view ?>">
					<?php $this->render_carousel_header(); ?>
					<?php
					foreach ( $settings['gallery'] as $image ) {
						$post_item_cls = 'post-item';
						if ( $selected_view == 'carousel' ) {
							$post_item_cls = ' swiper-slide';
						}
						?>
						<div class="<?php echo esc_html( $post_item_cls ); ?>">
							<article class="d-flex justify-content-center align-items-center" <?php post_class( array( 'post-wrapper', 'cart-hover-' . $hover_class ) ); ?>>
								<?php
								echo '<img src="' . esc_attr( $image['url'] ) . '">';
								?>
							</article>
						</div>
						<?php
					}
					?>
					<?php $this->render_carousel_footer(); ?>
                </div>
            </div>
			<script>
			jQuery( document ).ready( function ( $ )
			{
				var carouselPosts = $( '#theme-carousel-<?php echo $this->get_id() ?>' );

					// Get all elements with the class '.theme-posts-carousel-wrapper'
					var carouselSettings = $( carouselPosts ).data( 'settings' );

					// Find the swiper container within the current carousel
					var carouselContainer = $( carouselPosts ).find( '.swiper-container' )[ 0 ];

					// Initialize Swiper for the current carousel
					var swiper<?php echo $element_id;
					echo $widget_id; ?> = new Swiper( carouselContainer, carouselSettings );
					$( '.swiper-prev-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex > 0 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slidePrev();
						}
					} );

					$( '.swiper-next-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex < swiper<?php echo $element_id;
						  echo $widget_id; ?>.slides.length - 1 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slideNext();
						}
					} );

				} );
		</script>

			<?php
		}
	}

