<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_current_date extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_current_date';
    }

    public function get_title() {
        return esc_html__('Current Date', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_current_date';
    }


    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', THEME_NAME),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'date_format',
            [
                'label' => esc_html__( 'Date Format', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'l j F Y',
            ]
        );

        $this->add_control(
            'date_format_info',
            [
                'type'      => \Elementor\Controls_Manager::RAW_HTML,
                'raw'       => sprintf(esc_html__('%s Date Format Documentation %s', THEME_NAME), '<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank">', '</a>'),
            ]
        );

        $this->add_control(
            'text_align', [
                'label' => esc_html__('Alignment', THEME_NAME),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', THEME_NAME),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', THEME_NAME),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', THEME_NAME),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .current-date-wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('current_date',  '.date', $align=false);

        $this->end_controls_section();

    }

    protected function register_controls(){

        $this->register_content_section_1();

        $this->register_style_section_1();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $date_format = $settings['date_format'];
        ?>
        <div class="current-date-wrapper">
            <div class="current-date">
                <div class="date">
                    <?php echo convert_date( current_time( $settings['date_format'], true ), $date_format ); ?>
                </div>
            </div>
        </div>
        <?php
    }

}