<?php

$all_roles = wp_roles()->roles;

// Initialize an array to store the fields
$user_login_redirect_fields = array();
$user_loout_redirect_fields = array();

foreach ($all_roles as $role => $role_details) {
    // Generate the field ID and title
    $field_id = $role . '_login_redirect';
    $field_title = sprintf(esc_html__('%1$s Login Redirect URL', THEME_NAME), ucfirst($role) );

    
    // add the field configuration
    $user_login_redirect_fields[] = array(
        'id'       => $field_id,
        'type'     => 'text',
        'title'    => $field_title,
        'subtitle' => sprintf(esc_html__('Enter the URL where %s users will be redirected after login.', THEME_NAME), $role_details['name']),
        'default'  => '',
    );
}

foreach ($all_roles as $role => $role_details) {
    // Generate the field ID and title
    $field_id = $role . '_logout_redirect';
    $field_title = sprintf(esc_html__('%1$s Logout Redirect URL', THEME_NAME), ucfirst($role));

    // add the field configuration
    $user_login_redirect_fields[] = array(
        'id'       => $field_id,
        'type'     => 'text',
        'title'    => $field_title,
        'subtitle' => sprintf(esc_html__('Enter the URL where %s users will be redirected after logout.', THEME_NAME), $role_details['name']),
        'default'  => '',
    );
}

Redux::set_section($opt_name, array(
    'title'      => esc_html__('redirects', THEME_NAME),
    'id'         => 'redirects',
    'desc'       => esc_html__('inter your redircts here', THEME_NAME),
    'subsection' => false,
    'icon'       => 'isax isax-cloud-change',
    'fields'     =>  $user_login_redirect_fields
));
