<?php

$post_type_fields = array();

$post_type_fields = array(
        array(
            'id'        => 'general-sidebar-position',
            'type'      => 'select',
            'title'     => esc_html__('default Sidebar Position', THEME_NAME),
            'subtitle'  => esc_html__('Select sidebar position for default archive.', THEME_NAME),
            'desc'      => '',
            'options'   => array(
                'left'  => esc_html__('Left', THEME_NAME),
                'right' => esc_html__('Right', THEME_NAME),
                'none'  => esc_html__('No Sidebar', THEME_NAME),
            ),
            'select2'   => array( 'allowClear' => false ),
            'default'   => 'none',
        ),

        array(
            'id'       => 'general-sidebar-template',
            'type'     => 'select',
            'title'    => esc_html__('general Sidebar Template', THEME_NAME),
            'subtitle' => esc_html__('Select template for this sidebar.', THEME_NAME),
            'data'     => 'callback',
            'args'     => 'get_all_side_bar_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s sidebar Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-side-bar") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        ),

        array(
            'id'         => 'subtitle-d-1',
            'type'       => 'raw',
            'full_width' => true,
            'content'    => '<h4>' . esc_html__('Woocommerce Sidebar', THEME_NAME) . '</h4>',
        ),

        array(
            'id'        => 'woocommerce-archive-sidebar-position',
            'type'      => 'select',
            'title'     => esc_html__('Woocommerce Archive Sidebar Position', THEME_NAME),
            'subtitle'  => esc_html__('Select sidebar position for woocommerce archive.', THEME_NAME),
            'desc'      => '',
            'options'   => array(
                'left'  => esc_html__('Left', THEME_NAME),
                'right' => esc_html__('Right', THEME_NAME),
                'none'  => esc_html__('No Sidebar', THEME_NAME),
            ),
            'select2'   => array( 'allowClear' => false ),
            'default'   => 'none',
        ),

        array(
            'id'       => 'woocommerce-sidebar-template',
            'type'     => 'select',
            'title'    => esc_html__('Woocommerce Sidebar Template', THEME_NAME),
            'subtitle' => esc_html__('Select template for this sidebar.', THEME_NAME),
            'data'     => 'callback',
            'args'     => 'get_all_side_bar_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s sidebar Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-side-bar") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        ),

        array(
            'id'       => 'woocommerce-archive-sticky-sidebar',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Sidebar', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),
    );

$post_types_theme = theme_post_type();
foreach ($post_types_theme as $post_type) {
	if ( $post_type['name'] ) {

		$post_type_fields[] = array(
			'id' => 'subtitle-sidebar-' . $post_type['name'],
			'type' => 'raw',
			'full_width' => true,
			'content' => '<h4>' . sprintf( esc_html__( '%1$s sidebar', THEME_NAME ), $post_type['title'] ) . '</h4>',
		);


		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-archive-sidebar-position',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s archive Sidebar Position', THEME_NAME ), $post_type['title'] ),
			'desc' => '',
			'options' => array(
				'left' => esc_html__( 'Left', THEME_NAME ),
				'right' => esc_html__( 'Right', THEME_NAME ),
				'none' => esc_html__( 'No Sidebar', THEME_NAME ),
				'none-narrow' => esc_html__( 'No Sidebar + Narrow Content', THEME_NAME ),
			),
			'select2' => array( 'allowClear' => false ),
			'default' => 'none',
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-archive-sidebar',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s archive sidebar', THEME_NAME ), $post_type['title'] ),
			'data' => 'callback',
			'args' => 'get_all_side_bar_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s sidebar Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-side-bar" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-archive-sticky-sidebar',
			'type' => 'switch',
			'title' => esc_html__( 'Sticky Sidebar', THEME_NAME ),
			'desc' => '',
			'default' => true,
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-sidebar-position',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s Sidebar Position', THEME_NAME ), $post_type['title'] ),
			'desc' => '',
			'options' => array(
				'left' => esc_html__( 'Left', THEME_NAME ),
				'right' => esc_html__( 'Right', THEME_NAME ),
				'none' => esc_html__( 'No Sidebar', THEME_NAME ),
				'none-narrow' => esc_html__( 'No Sidebar + Narrow Content', THEME_NAME ),
			),
			'select2' => array( 'allowClear' => false ),
			'default' => 'none',
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-sidebar',
			'type' => 'select',
			'title' => sprintf( esc_html__( '%1$s sidebar', THEME_NAME ), $post_type['title'] ),
			'data' => 'callback',
			'args' => 'get_all_side_bar_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s sidebar Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-side-bar" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);

		$post_type_fields[] = array(
			'id' => $post_type['name'] . '-sticky-sidebar',
			'type' => 'switch',
			'title' => esc_html__( 'Sticky Sidebar', THEME_NAME ),
			'desc' => '',
			'default' => true,
		);
	}
}

$post_types = get_post_types(array('public' => true,), 'objects');
$excluded_post_types = array('attachment', 'elementor_library', 'e-landing-page');

// Filter out excluded post types
foreach ($excluded_post_types as $exclude_type) {
    if (isset($post_types[$exclude_type])) {
        unset($post_types[$exclude_type]);
    }
}
foreach ($post_types as $post_type) {
    $post_type_fields[] = array(
        'id'         => 'subtitle-sidebar-'. $post_type->name,
        'type'       => 'raw',
        'full_width' => true,
        'content'    => '<h4>' . sprintf(esc_html__('%1$s sidebar', THEME_NAME), $post_type->labels->name) . '</h4>',
    );

    
    if($post_type->name != 'page'){ 
        $post_type_fields[] = array(
            'id'              => $post_type->name . '-archive-sidebar-position',
            'type'            => 'select',
            'title'           => sprintf(esc_html__('%1$s archive Sidebar Position', THEME_NAME), $post_type->labels->name ),
            'desc'            => '',
            'options'         => array(
                'left'        => esc_html__('Left', THEME_NAME),
                'right'       => esc_html__('Right', THEME_NAME),
                'none'        => esc_html__('No Sidebar', THEME_NAME),
                'none-narrow' => esc_html__('No Sidebar + Narrow Content', THEME_NAME),
            ),
            'select2'         => array( 'allowClear' => false ),
            'default'         => 'none',
        );

        $post_type_fields[] = array(
            'id'       => $post_type->name .'-archive-sidebar',
            'type'     => 'select',
            'title'    => sprintf(esc_html__('%1$s archive sidebar', THEME_NAME), $post_type->labels->name),
            'data'     => 'callback',
            'args'     => 'get_all_side_bar_template',
            'desc'     => sprintf(esc_html__('create your template in %1$s sidebar Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-side-bar") . '"><b>', '</b></a>'),
            'default'  => '0',
            'select2'  => array( 'allowClear' => false ),
        );
    
        $post_type_fields[] = array(
            'id'       => $post_type->name .'-archive-sticky-sidebar',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Sidebar', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        );
    }

    $post_type_fields[] = array(
            'id'              => $post_type->name . '-sidebar-position',
            'type'            => 'select',
            'title'           => sprintf(esc_html__('%1$s Sidebar Position', THEME_NAME), $post_type->labels->name),
            'desc'            => '',
            'options'         => array(
                'left'        => esc_html__('Left', THEME_NAME),
                'right'       => esc_html__('Right', THEME_NAME),
                'none'        => esc_html__('No Sidebar', THEME_NAME),
                'none-narrow' => esc_html__('No Sidebar + Narrow Content', THEME_NAME),
            ),
            'select2'  => array( 'allowClear' => false ),
            'default'  => 'none',
        );

    $post_type_fields[] = array(
        'id'       => $post_type->name .'-sidebar',
        'type'     => 'select',
        'title'    => sprintf(esc_html__('%1$s sidebar', THEME_NAME), $post_type->labels->name),
        'data'     => 'callback',
        'args'     => 'get_all_side_bar_template',
        'desc'     => sprintf(esc_html__('create your template in %1$s sidebar Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-side-bar") . '"><b>', '</b></a>'),
        'default'  => '0',
        'select2'  => array( 'allowClear' => false ),
    );

    $post_type_fields[] = array(
        'id'       => $post_type->name .'-sticky-sidebar',
        'type'     => 'switch',
        'title'    => esc_html__('Sticky Sidebar', THEME_NAME),
        'desc'     => '',
        'default'  => true,
    );
}
Redux::set_section( $opt_name, array(
    'title'       =>  esc_html__('Sidebar', THEME_NAME),
    'id'          => 'sidebar_section',
    'desc'        =>  esc_html__('General settings for sidebar', THEME_NAME),
    'icon'        => 'isax isax-sidebar-left',
    'fields'      => $post_type_fields,
) );